/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.core.device.usbscsi.exception;

import com.zkteco.android.biometric.core.exception.BiometricTransportException;

public class USBSCSITransportException
extends BiometricTransportException {
    private static final String INIT_USB_DEVICE_FAILED = "Initialize USB device failed";
    private static final String OPEN_INVALID_USB_DEVICE = "Try to open a invalid USB device";
    private static final String OPEN_DEVICE_FAILED = "Open USB device failed";
    private static final String INVALID_BUFFER_LENGTH = "Invalid buffer length, buffer length is less than specified length";
    private static final String CONTROL_INVALID_USB_DEVICE = "Control invalid USB device";
    private static final String CONTROL_USB_DEVICE_FAILED = "Control USB device failed";
    private static final String READ_USB_DEVICE_FAILED = "Read USB device failed";
    private static final String WRITE_USB_DEVICE_FAILED = "Write USB device failed";
    private static final String CLOSE_USB_DEVICE_FAILED = "Close USB device failed";
    private static final String FREE_USB_DEVICE_FAILED = "Free USB device failed";

    USBSCSITransportException(String message, int errorCode) {
        super(message, errorCode);
    }

    USBSCSITransportException(String message, int errorCode, int internalErrorCode) {
        super(message, errorCode, internalErrorCode);
    }

    public static USBSCSITransportException initUSBDeviceFailed() {
        return new USBSCSITransportException(INIT_USB_DEVICE_FAILED, -1);
    }

    public static USBSCSITransportException openInvaliedUSBDevice() {
        return new USBSCSITransportException(OPEN_INVALID_USB_DEVICE, -2);
    }

    public static USBSCSITransportException openUSBDeviceFailed() {
        return new USBSCSITransportException(OPEN_DEVICE_FAILED, -3);
    }

    public static USBSCSITransportException operateInvalidUSBDevice() {
        return new USBSCSITransportException(CONTROL_INVALID_USB_DEVICE, -5);
    }

    public static USBSCSITransportException invalidBufferLength() {
        return new USBSCSITransportException(INVALID_BUFFER_LENGTH, -4);
    }

    public static USBSCSITransportException controlUSBDeviceFailed(int internalErrorCode) {
        return new USBSCSITransportException(CONTROL_USB_DEVICE_FAILED, -6, internalErrorCode);
    }

    public static USBSCSITransportException readUSBDeviceFailed(int internalErrorCode) {
        return new USBSCSITransportException(READ_USB_DEVICE_FAILED, -7, internalErrorCode);
    }

    public static USBSCSITransportException writeUSBDeviceFailed(int internalErrorCode) {
        return new USBSCSITransportException(WRITE_USB_DEVICE_FAILED, -8, internalErrorCode);
    }

    public static USBSCSITransportException closeUSBTransportException(int errorCode) {
        return new USBSCSITransportException(CLOSE_USB_DEVICE_FAILED, errorCode);
    }

    public static USBSCSITransportException freeUSBDeviceFailed(int errorCode) {
        return new USBSCSITransportException(FREE_USB_DEVICE_FAILED, errorCode);
    }
}

