/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.core.device.usb.exception;

import com.zkteco.android.biometric.core.exception.BiometricTransportException;

public class USBTransportException
extends BiometricTransportException {
    private static final String INIT_USB_DEVICE_FAILED = "Initialize USB device failed";
    private static final String OPEN_INVALID_USB_DEVICE = "Try to open a invalid USB device";
    private static final String OPEN_DEVICE_FAILED = "Open USB device failed";
    private static final String INVALID_BUFFER_LENGTH = "Invalid buffer length, buffer length is less than specified length";
    private static final String CONTROL_INVALID_USB_DEVICE = "Control invalid USB device";
    private static final String CONTROL_USB_DEVICE_FAILED = "Control USB device failed";
    private static final String READ_USB_DEVICE_FAILED = "Read USB device failed";
    private static final String WRITE_USB_DEVICE_FAILED = "Write USB device failed";
    private static final String CLOSE_USB_DEVICE_FAILED = "Close USB device failed";
    private static final String FREE_USB_DEVICE_FAILED = "Free USB device failed";

    USBTransportException(String message, int errorCode) {
        super(message, errorCode);
    }

    USBTransportException(String message, int errorCode, int internalErrorCode) {
        super(message, errorCode, internalErrorCode);
    }

    public static USBTransportException initUSBDeviceFailed() {
        return new USBTransportException(INIT_USB_DEVICE_FAILED, -1);
    }

    public static USBTransportException openInvaliedUSBDevice() {
        return new USBTransportException(OPEN_INVALID_USB_DEVICE, -2);
    }

    public static USBTransportException openUSBDeviceFailed() {
        return new USBTransportException(OPEN_DEVICE_FAILED, -3);
    }

    public static USBTransportException operateInvalidUSBDevice() {
        return new USBTransportException(CONTROL_INVALID_USB_DEVICE, -5);
    }

    public static USBTransportException invalidBufferLength() {
        return new USBTransportException(INVALID_BUFFER_LENGTH, -4);
    }

    public static USBTransportException controlUSBDeviceFailed(int internalErrorCode) {
        return new USBTransportException(CONTROL_USB_DEVICE_FAILED, -6, internalErrorCode);
    }

    public static USBTransportException readUSBDeviceFailed(int internalErrorCode) {
        return new USBTransportException(READ_USB_DEVICE_FAILED, -7, internalErrorCode);
    }

    public static USBTransportException writeUSBDeviceFailed(int internalErrorCode) {
        return new USBTransportException(WRITE_USB_DEVICE_FAILED, -8, internalErrorCode);
    }

    public static USBTransportException closeUSBTransportException(int errorCode) {
        return new USBTransportException(CLOSE_USB_DEVICE_FAILED, errorCode);
    }

    public static USBTransportException freeUSBDeviceFailed(int errorCode) {
        return new USBTransportException(FREE_USB_DEVICE_FAILED, errorCode);
    }
}

