/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.module.idcard;

import android.content.Context;
import com.zkteco.android.biometric.SDTAPIService;
import com.zkteco.android.biometric.core.device.BiometricDevice;
import com.zkteco.android.biometric.core.device.TransportType;
import com.zkteco.android.biometric.core.exception.BiometricTransportException;
import com.zkteco.android.biometric.core.utils.LogHelper;
import com.zkteco.android.biometric.core.utils.ToolUtils;
import com.zkteco.android.biometric.module.idcard.IDCardReaderInterface;
import com.zkteco.android.biometric.module.idcard.exception.IDCardReaderException;
import com.zkteco.android.biometric.module.idcard.meta.ICCardReaderRetData;
import com.zkteco.android.biometric.module.idcard.meta.ICCardReaderSendData;
import com.zkteco.android.biometric.module.idcard.meta.IDCardInfo;
import com.zkteco.android.biometric.module.idcard.meta.IDCardReaderRetData;
import com.zkteco.android.biometric.module.idcard.meta.IDCardReaderSendData;
import com.zkteco.android.biometric.module.idcard.meta.IDPRPCardInfo;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Map;

public class IDCardReader
extends BiometricDevice
implements IDCardReaderInterface {
    private int VID = 1024;
    private int PID = 50010;
    protected Object deviceLock = new Object();
    private String version = "NIDReader 2.0.21\t20180820";
    private IDCardInfo mIDCardInfo = null;
    private IDPRPCardInfo mPRPIDCardInfo = null;
    private int BaudRate = -1;
    private boolean mbLibusb = false;
    private boolean mbUSBHostAPI = true;
    private long mHandle = 0L;
    private byte[] mOutBuffer = new byte[4096];
    private byte[] mInBuffer = new byte[4096];
    private byte[] mTempBuffer = new byte[4096];
    IDCardReaderSendData idCardReaderSendData = new IDCardReaderSendData();
    IDCardReaderRetData idCardReaderRetData = new IDCardReaderRetData();
    ICCardReaderSendData icCardReaderSendData = new ICCardReaderSendData();
    ICCardReaderRetData icCardReaderRetData = new ICCardReaderRetData();

    private void freeIDCardData() {
        this.idCardReaderSendData.free();
        this.idCardReaderRetData.free();
    }

    private void freeICCardData() {
        this.icCardReaderSendData.free();
        this.icCardReaderRetData.free();
    }

    public IDCardInfo getLastIDCardInfo() {
        return this.mIDCardInfo;
    }

    public IDPRPCardInfo getLastPRPIDCardInfo() {
        return this.mPRPIDCardInfo;
    }

    public IDCardReader(Context context, TransportType transportType, Map<String, Object> parameters) {
        super(context, transportType, parameters);
    }

    public void setLibusbFlag(boolean blibUsb) {
        this.mbLibusb = blibUsb;
    }

    public void setUsedHostAPI(boolean bUSBHostAPI, int vid, int pid) {
        this.mbUSBHostAPI = bUSBHostAPI;
        if (!this.mbUSBHostAPI) {
            this.VID = vid;
            this.PID = pid;
            this.mbLibusb = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(int index) throws IDCardReaderException {
        Object object = this.deviceLock;
        synchronized (object) {
            try {
                if (this.mbUSBHostAPI) {
                    this.transportDevice.init();
                    this.transportDevice.open(index);
                    if (this.mbLibusb && this.transportDevice.getType() == TransportType.USB) {
                        int[] vid = new int[1];
                        int[] pid = new int[1];
                        int[] fd = new int[1];
                        int[] inPoint = new int[1];
                        int[] outPoint = new int[1];
                        this.transportDevice.getUsbConnectionConfig(index, vid, pid, fd, inPoint, outPoint);
                        this.mHandle = SDTAPIService.OpenDevice(vid[0], pid[0], fd[0], inPoint[0], outPoint[0]);
                        if (0L == this.mHandle) {
                            LogHelper.e((String)"Open idcardreader failed, because libusb open failed");
                            throw IDCardReaderException.openIDCardReaderFailed(-30001);
                        }
                    } else if (this.BaudRate != -1) {
                        this.transportDevice.SetConfigUsb(0, this.BaudRate);
                        byte[] buf = new byte[8192];
                        this.transportDevice.read(index, buf, 4096, 1000);
                    }
                } else {
                    this.mHandle = SDTAPIService.OpenDevice(this.VID, this.PID, -1, 0, 0);
                    if (0L == this.mHandle) {
                        LogHelper.e((String)"Open idcardreader failed, because libusb open failed");
                        throw IDCardReaderException.openIDCardReaderFailed(-30001);
                    }
                }
            }
            catch (BiometricTransportException e) {
                LogHelper.e((String)("Open idcardreader " + index + " failed!Reason: " + e.getMessage() + "Internal error code: " + e.getErrorCode()));
                throw IDCardReaderException.openIDCardReaderFailed(e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(int index) throws IDCardReaderException {
        Object object = this.deviceLock;
        synchronized (object) {
            try {
                if (this.mbLibusb && 0L != this.mHandle) {
                    SDTAPIService.CloseDevice(this.mHandle);
                }
                this.mHandle = 0L;
                if (this.mbUSBHostAPI) {
                    this.transportDevice.close(index);
                    this.transportDevice.free(index);
                }
            }
            catch (BiometricTransportException e) {
                LogHelper.e((String)("Close idcardreader " + index + " failed!Reason: " + e.getMessage() + "Internal error code: " + e.getErrorCode()));
                throw IDCardReaderException.closeIDCardReaderFailed(e.getErrorCode());
            }
        }
    }

    private void controlDevice(int index, IDCardReaderSendData idCardReaderSendData, IDCardReaderRetData idCardReaderRetData, int timeout) throws IDCardReaderException {
        if (this.transportDevice.getType() == TransportType.USB) {
            this.controlDevice_usb(index, idCardReaderSendData, idCardReaderRetData, timeout);
        } else if (this.transportDevice.getType() == TransportType.USBHID) {
            this.controlDevice_HID(index, idCardReaderSendData, idCardReaderRetData, timeout);
        } else {
            this.controlDevice_serial(index, idCardReaderSendData, idCardReaderRetData, timeout);
        }
    }

    private void ic_controlDevice(int index, ICCardReaderSendData icCardReaderSendData, ICCardReaderRetData icCardReaderRetData, int timeout) throws IDCardReaderException {
        if (this.transportDevice.getType() == TransportType.USB) {
            this.ic_controlDevice_usb(index, icCardReaderSendData, icCardReaderRetData, timeout);
        } else {
            this.ic_controlDevice_serial(index, icCardReaderSendData, icCardReaderRetData, timeout);
        }
    }

    private void controlDevice_usb(int index, IDCardReaderSendData idCardReaderSendData, IDCardReaderRetData idCardReaderRetData, int timeout) throws IDCardReaderException {
        Arrays.fill(this.mTempBuffer, (byte)0);
        Arrays.fill(this.mOutBuffer, (byte)0);
        try {
            this.transportDevice.read(index, this.mTempBuffer, 4096, 5);
        }
        catch (BiometricTransportException e) {
            e.printStackTrace();
        }
        try {
            int length = idCardReaderSendData.getPacketLen();
            if (!idCardReaderSendData.packet(this.mInBuffer)) {
                LogHelper.e((String)"controlDevice faile! Reason: invalid data");
                throw IDCardReaderException.controlIDCardDeviceFailed(-20004);
            }
            this.transportDevice.write(index, this.mInBuffer, length, timeout);
            if (this.transportDevice.read(index, this.mOutBuffer, 4096, timeout) == 0) {
                LogHelper.e((String)"controlDevice faile! Reason: read timeout");
                throw IDCardReaderException.controlIDCardDeviceFailed(-20012);
            }
            ToolUtils.outputHexString((byte[])this.mOutBuffer);
            if (!idCardReaderRetData.unPacket(this.mOutBuffer)) {
                LogHelper.e((String)"controlDevice faile! Reason: unpacket fail");
                throw IDCardReaderException.controlIDCardDeviceFailed(-20004);
            }
            if (idCardReaderRetData.calcCheckSum() != idCardReaderRetData.getChecksum()) {
                LogHelper.e((String)"controlDevice faile! Reason: wrong checksum");
                throw IDCardReaderException.controlIDCardDeviceFailed(-20005);
            }
        }
        catch (BiometricTransportException e) {
            LogHelper.e((String)("controlDevice " + index + " failed!Reason: " + e.getMessage() + "Internal error code: " + e.getErrorCode()));
            throw IDCardReaderException.controlIDCardDeviceFailed(e.getErrorCode());
        }
    }

    private void ic_controlDevice_usb(int index, ICCardReaderSendData icCardReaderSendData, ICCardReaderRetData icCardReaderRetData, int timeout) throws IDCardReaderException {
        Arrays.fill(this.mTempBuffer, (byte)0);
        Arrays.fill(this.mOutBuffer, (byte)0);
        try {
            this.transportDevice.read(index, this.mTempBuffer, 4096, 5);
        }
        catch (BiometricTransportException e) {
            e.printStackTrace();
        }
        try {
            int length = icCardReaderSendData.getPacketLen();
            if (!icCardReaderSendData.Packet(this.mInBuffer)) {
                LogHelper.e((String)"controlDevice faile! Reason: invalid data");
                throw IDCardReaderException.controlIDCardDeviceFailed(-20004);
            }
            this.transportDevice.write(index, this.mInBuffer, length, timeout);
            if (this.transportDevice.read(index, this.mOutBuffer, 4096, timeout) == 0) {
                LogHelper.e((String)"controlDevice faile! Reason: read timeout");
                throw IDCardReaderException.controlIDCardDeviceFailed(-20012);
            }
            ToolUtils.outputHexString((byte[])this.mOutBuffer);
            if (!icCardReaderRetData.UnPacket(this.mOutBuffer)) {
                LogHelper.e((String)"controlDevice faile! Reason: unpacket fail");
                throw IDCardReaderException.controlIDCardDeviceFailed(-20004);
            }
            if (icCardReaderRetData.calcCheckSum() != icCardReaderRetData.getChecksum()) {
                LogHelper.e((String)"controlDevice faile! Reason: wrong checksum");
                throw IDCardReaderException.controlIDCardDeviceFailed(-20005);
            }
        }
        catch (BiometricTransportException e) {
            LogHelper.e((String)("controlDevice " + index + " failed!Reason: " + e.getMessage() + "Internal error code: " + e.getErrorCode()));
            throw IDCardReaderException.controlIDCardDeviceFailed(e.getErrorCode());
        }
    }

    private void resetPort(int index) {
        try {
            this.transportDevice.read(index, this.mTempBuffer, this.mTempBuffer.length, 10);
        }
        catch (BiometricTransportException e) {
            e.printStackTrace();
        }
    }

    private boolean sendBuffer(int index, byte[] buffer, int length, int timeout) {
        boolean result = true;
        try {
            this.transportDevice.write(index, buffer, length, timeout);
        }
        catch (BiometricTransportException e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    private int readBuffer(int index, byte[] buffer, int length, int timeout) {
        int size = 0;
        try {
            size = this.transportDevice.read(index, buffer, length, timeout);
        }
        catch (BiometricTransportException e) {
            e.printStackTrace();
            size = 0;
        }
        return size;
    }

    private boolean controlDevice_serial(int index, IDCardReaderSendData idCardReaderSendData, IDCardReaderRetData idCardReaderRetData, int timeout) {
        int length = idCardReaderSendData.getPacketLen();
        if (!idCardReaderSendData.packet(this.mInBuffer)) {
            return false;
        }
        this.resetPort(index);
        if (this.sendBuffer(index, this.mInBuffer, length, 500)) {
            long tickStart = System.currentTimeMillis();
            int totalsize = 11;
            int readSize = 0;
            int realLen = 0;
            int requestLen = this.mTempBuffer.length;
            while (System.currentTimeMillis() - tickStart < (long)timeout) {
                int size = this.readBuffer(index, this.mTempBuffer, requestLen, 200);
                if (size > 0) {
                    System.arraycopy(this.mTempBuffer, 0, this.mOutBuffer, readSize, size);
                    readSize += size;
                }
                if (realLen == 0 && readSize >= totalsize) {
                    totalsize = realLen = idCardReaderRetData.preGetDataLen(this.mOutBuffer);
                }
                if (size > 0 && realLen > 0) {
                    requestLen = totalsize - readSize;
                }
                if (readSize < totalsize) continue;
                break;
            }
            return readSize >= totalsize && idCardReaderRetData.unPacket(this.mOutBuffer);
        }
        return false;
    }

    private boolean controlDevice_HID(int index, IDCardReaderSendData idCardReaderSendData, IDCardReaderRetData idCardReaderRetData, int timeout) {
        int length = idCardReaderSendData.getHIDPacketLen();
        if (!idCardReaderSendData.packetHID(this.mInBuffer)) {
            return false;
        }
        this.resetPort(index);
        if (this.sendBuffer(index, this.mInBuffer, length, 500)) {
            long tickStart = System.currentTimeMillis();
            int totalsize = 6;
            int readSize = 0;
            int realLen = 0;
            int requestLen = this.mTempBuffer.length;
            while (System.currentTimeMillis() - tickStart < (long)timeout) {
                int size = this.readBuffer(index, this.mTempBuffer, requestLen, 200);
                if (size > 0) {
                    System.arraycopy(this.mTempBuffer, 0, this.mOutBuffer, readSize, size);
                    readSize += size;
                }
                if (realLen == 0 && readSize >= totalsize) {
                    totalsize = realLen = idCardReaderRetData.preGetHIDDataLen(this.mOutBuffer);
                }
                if (size > 0 && realLen > 0) {
                    requestLen = totalsize - readSize;
                }
                if (readSize < totalsize) continue;
                break;
            }
            return readSize >= totalsize && idCardReaderRetData.unPacketHID(this.mOutBuffer);
        }
        return false;
    }

    private boolean ic_controlDevice_serial(int index, ICCardReaderSendData icCardReaderSendData, ICCardReaderRetData icCardReaderRetData, int timeout) {
        int length = icCardReaderSendData.getPacketLen();
        if (!icCardReaderSendData.Packet(this.mInBuffer)) {
            return false;
        }
        this.resetPort(index);
        if (this.sendBuffer(index, this.mInBuffer, length, 500)) {
            long tickStart = System.currentTimeMillis();
            int totalsize = 6;
            int readSize = 0;
            int realLen = 0;
            int requestSize = this.mTempBuffer.length;
            while (System.currentTimeMillis() - tickStart < (long)timeout) {
                int size = this.readBuffer(index, this.mTempBuffer, requestSize, 200);
                if (size > 0) {
                    System.arraycopy(this.mTempBuffer, 0, this.mOutBuffer, readSize, size);
                    readSize += size;
                }
                if (realLen == 0 && readSize >= totalsize) {
                    totalsize = realLen = icCardReaderRetData.PreGetLen(this.mOutBuffer);
                }
                if (size > 0 && realLen > 0) {
                    requestSize = totalsize - readSize;
                }
                if (readSize < totalsize) continue;
                break;
            }
            return readSize >= totalsize && icCardReaderRetData.UnPacket(this.mOutBuffer);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reset(int index) throws IDCardReaderException {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.mbLibusb) {
                if (0L != this.mHandle) {
                    int ret = SDTAPIService.Reset(this.mHandle);
                    if ((byte)ret != -112) {
                        throw IDCardReaderException.resetIDCardDeviceFailed(-21000 - (byte)ret);
                    }
                    return true;
                }
                throw IDCardReaderException.resetIDCardDeviceFailed(-20001);
            }
            boolean ret = false;
            try {
                this.freeIDCardData();
                this.idCardReaderSendData.setCmd((byte)16);
                this.idCardReaderSendData.setPara((byte)-1);
                this.controlDevice(index, this.idCardReaderSendData, this.idCardReaderRetData, 2000);
                byte retSw3 = this.idCardReaderRetData.getSw3();
                if (retSw3 != -112) {
                    throw IDCardReaderException.resetIDCardDeviceFailed(-21000 - retSw3);
                }
                ret = true;
            }
            catch (IDCardReaderException e) {
                LogHelper.e((String)("sdtapiReset " + index + " failed!Reason: " + e.getMessage() + "Error code: " + e.getErrorCode() + "Internal error code: " + e.getInternalErrorCode()));
                throw IDCardReaderException.resetIDCardDeviceFailed(e.getErrorCode());
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getStatus(int index) throws IDCardReaderException {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.mbLibusb) {
                if (0L != this.mHandle) {
                    int ret = SDTAPIService.Status(this.mHandle);
                    if ((byte)ret != -112) {
                        throw IDCardReaderException.getstatusIDCardDeviceFailed(-21000 - (byte)ret);
                    }
                    return true;
                }
                throw IDCardReaderException.getstatusIDCardDeviceFailed(-20001);
            }
            boolean ret = false;
            try {
                this.freeIDCardData();
                this.idCardReaderSendData.setCmd((byte)17);
                this.idCardReaderSendData.setPara((byte)-1);
                this.controlDevice(index, this.idCardReaderSendData, this.idCardReaderRetData, 2000);
                byte retSw3 = this.idCardReaderRetData.getSw3();
                if (retSw3 != -112) {
                    throw IDCardReaderException.getstatusIDCardDeviceFailed(-21000 - retSw3);
                }
                ret = true;
            }
            catch (IDCardReaderException e) {
                LogHelper.e((String)("sdtapiStatus " + index + " failed!Reason: " + e.getMessage() + "Error code: " + e.getErrorCode() + "Internal error code: " + e.getInternalErrorCode()));
                throw IDCardReaderException.getstatusIDCardDeviceFailed(e.getErrorCode());
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSAMIDBuffer(int index) throws IDCardReaderException {
        byte[] bufRet = null;
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.mbLibusb) {
                return null;
            }
            this.freeIDCardData();
            this.idCardReaderSendData.setCmd((byte)18);
            this.idCardReaderSendData.setPara((byte)-1);
            this.controlDevice(index, this.idCardReaderSendData, this.idCardReaderRetData, 2000);
            byte retSw3 = this.idCardReaderRetData.getSw3();
            if (retSw3 != -112) {
                throw IDCardReaderException.getstatusIDCardDeviceFailed(-21000 - retSw3);
            }
            int len = this.idCardReaderRetData.getDataLen();
            if (len > 0) {
                bufRet = new byte[len];
                this.idCardReaderRetData.getData(bufRet);
            }
        }
        return bufRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSAMID(int index) throws IDCardReaderException {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.mbLibusb) {
                if (0L != this.mHandle) {
                    byte[] bufSAMID = new byte[256];
                    int[] retSize = new int[]{256};
                    int ret = SDTAPIService.GetSAMIDStr(this.mHandle, bufSAMID, retSize);
                    if ((byte)ret != -112) {
                        throw IDCardReaderException.getstatusIDCardDeviceFailed(-21000 - ret);
                    }
                    return new String(bufSAMID, 0, retSize[0]);
                }
                throw IDCardReaderException.getstatusIDCardDeviceFailed(-20001);
            }
            String samID = "";
            try {
                this.freeIDCardData();
                this.idCardReaderSendData.setCmd((byte)18);
                this.idCardReaderSendData.setPara((byte)-1);
                this.controlDevice(index, this.idCardReaderSendData, this.idCardReaderRetData, 2000);
                byte retSw3 = this.idCardReaderRetData.getSw3();
                if (retSw3 != -112) {
                    throw IDCardReaderException.getstatusIDCardDeviceFailed(-21000 - retSw3);
                }
                int length = this.idCardReaderRetData.getDataLen();
                byte[] bufSamid = new byte[length];
                this.idCardReaderRetData.getData(bufSamid);
                Formatter fmt = new Formatter();
                int date = bufSamid[4] & 0xFF;
                date += bufSamid[5] << 8 & 0xFF00;
                date += bufSamid[6] << 16 & 0xFF0000;
                date += bufSamid[7] << 24 & 0xFF000000;
                int unknow1 = bufSamid[8] & 0xFF;
                unknow1 += bufSamid[9] << 8 & 0xFF00;
                unknow1 += bufSamid[10] << 16 & 0xFF0000;
                int unknow2 = bufSamid[12] & 0xFF;
                unknow2 += bufSamid[13] << 8 & 0xFF00;
                unknow2 += bufSamid[14] << 16 & 0xFF0000;
                fmt.format("%d%d%d%d%d000%d%d", bufSamid[1], bufSamid[0], bufSamid[3], bufSamid[2], date, unknow1 += bufSamid[11] << 24 & 0xFF000000, unknow2 += bufSamid[15] << 24 & 0xFF000000);
                samID = fmt.toString();
            }
            catch (IDCardReaderException e) {
                LogHelper.e((String)("sdtapiSAMID " + index + " failed!Reason: " + e.getMessage() + "Error code: " + e.getErrorCode() + "Internal error code: " + e.getInternalErrorCode()));
                throw IDCardReaderException.getstatusIDCardDeviceFailed(e.getErrorCode());
            }
            return samID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean findCard(int index) throws IDCardReaderException {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.mbLibusb) {
                if (this.mHandle != 0L) {
                    byte[] buffer = new byte[32];
                    int ret = SDTAPIService.FindIDCard(this.mHandle, buffer);
                    if ((byte)ret != -97) {
                        throw IDCardReaderException.findCardIDCardDeviceFailed(-21000 - ret);
                    }
                    return true;
                }
                throw IDCardReaderException.findCardIDCardDeviceFailed(-20001);
            }
            boolean ret = false;
            try {
                this.freeIDCardData();
                this.idCardReaderSendData.setCmd((byte)32);
                this.idCardReaderSendData.setPara((byte)1);
                this.controlDevice(index, this.idCardReaderSendData, this.idCardReaderRetData, 2000);
                byte retSw3 = this.idCardReaderRetData.getSw3();
                if (retSw3 != -97) {
                    throw IDCardReaderException.findCardIDCardDeviceFailed(-21000 - retSw3);
                }
                ret = true;
            }
            catch (IDCardReaderException e) {
                LogHelper.e((String)("sdtapiFind " + index + " failed!Reason: " + e.getMessage() + "Error code: " + e.getErrorCode() + "Internal error code: " + e.getInternalErrorCode()));
                throw IDCardReaderException.findCardIDCardDeviceFailed(e.getErrorCode());
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean selectCard(int index) throws IDCardReaderException {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.mbLibusb) {
                if (this.mHandle != 0L) {
                    byte[] buffer = new byte[32];
                    int ret = SDTAPIService.SelectIDCard(this.mHandle, buffer);
                    if ((byte)ret != -112) {
                        throw IDCardReaderException.selectCardIDCardDeviceFailed(-21000 - ret);
                    }
                    return true;
                }
                throw IDCardReaderException.selectCardIDCardDeviceFailed(-20001);
            }
            boolean ret = false;
            try {
                this.freeIDCardData();
                this.idCardReaderSendData.setCmd((byte)32);
                this.idCardReaderSendData.setPara((byte)2);
                this.controlDevice(index, this.idCardReaderSendData, this.idCardReaderRetData, 2000);
                byte retSw3 = this.idCardReaderRetData.getSw3();
                if (retSw3 != -112) {
                    throw IDCardReaderException.selectCardIDCardDeviceFailed(-21000 - retSw3);
                }
                ret = true;
            }
            catch (IDCardReaderException e) {
                LogHelper.e((String)("sdtapiSelect " + index + " failed!Reason: " + e.getMessage() + "Error code: " + e.getErrorCode() + "Internal error code: " + e.getInternalErrorCode()));
                throw IDCardReaderException.selectCardIDCardDeviceFailed(e.getErrorCode());
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readCardManageNum(int index, byte[] ICSerialNumber, byte[] cardSerialNum) throws IDCardReaderException {
        Object object = this.deviceLock;
        synchronized (object) {
            if (null == ICSerialNumber || null == cardSerialNum || ICSerialNumber.length < 8 || cardSerialNum.length < 16) {
                return false;
            }
            if (this.mbLibusb) {
                if (this.mHandle != 0L) {
                    byte[] buffer = new byte[24];
                    int ret = SDTAPIService.ReadCardManage(this.mHandle, buffer);
                    if ((byte)ret != -112) {
                        throw IDCardReaderException.selectCardIDCardDeviceFailed(-21000 - ret);
                    }
                    System.arraycopy(buffer, 0, ICSerialNumber, 0, 8);
                    System.arraycopy(buffer, 8, cardSerialNum, 0, 16);
                    return true;
                }
                throw IDCardReaderException.ReadCardManageFaile(-20001);
            }
            boolean ret = false;
            try {
                this.freeIDCardData();
                this.idCardReaderSendData.setCmd((byte)48);
                this.idCardReaderSendData.setPara((byte)5);
                this.controlDevice(index, this.idCardReaderSendData, this.idCardReaderRetData, 2000);
                byte retSw3 = this.idCardReaderRetData.getSw3();
                if (retSw3 != -112) {
                    throw IDCardReaderException.selectCardIDCardDeviceFailed(-21000 - retSw3);
                }
                byte[] buffer = new byte[24];
                this.idCardReaderRetData.getData(buffer);
                System.arraycopy(buffer, 0, ICSerialNumber, 0, 8);
                System.arraycopy(buffer, 8, cardSerialNum, 0, 16);
                ret = true;
            }
            catch (IDCardReaderException e) {
                LogHelper.e((String)("sdtapiSelect " + index + " failed!Reason: " + e.getMessage() + "Error code: " + e.getErrorCode() + "Internal error code: " + e.getInternalErrorCode()));
                throw IDCardReaderException.ReadCardManageFaile(e.getErrorCode());
            }
            return ret;
        }
    }

    private int readCard_Imp(int index, int action, IDCardInfo idCardInfo) {
        this.mIDCardInfo = null;
        this.mPRPIDCardInfo = null;
        int ret = 0;
        try {
            if (this.mbLibusb) {
                if (0L == this.mHandle) {
                    throw IDCardReaderException.readCardIDCardDeviceFailed(-20001);
                }
                int[] size = new int[]{4096};
                if (action == 0) {
                    ret = SDTAPIService.ReadBaseMsgBuffer(this.mHandle, this.mOutBuffer, size);
                } else if (action == 1) {
                    ret = SDTAPIService.ReadBaseFPMsgBuffer(this.mHandle, this.mOutBuffer, size);
                } else {
                    throw IDCardReaderException.readCardIDCardDeviceFailed(-20011);
                }
                if ((byte)ret != -112) {
                    throw IDCardReaderException.readCardIDCardDeviceFailed(-21000 - ret);
                }
                if (action == 0) {
                    int licType = IDPRPCardInfo.CheckType(this.mOutBuffer, size[0]);
                    if (licType == 2) {
                        this.mPRPIDCardInfo = new IDPRPCardInfo();
                        this.mPRPIDCardInfo.unPacket(this.mOutBuffer, size[0]);
                        ret = licType;
                    } else if (licType == 1 || licType == 3) {
                        this.mIDCardInfo = null != idCardInfo ? idCardInfo : new IDCardInfo();
                        this.mIDCardInfo.setCardType(licType);
                        this.mIDCardInfo.unPacket(this.mOutBuffer, size[0]);
                        ret = licType;
                    } else {
                        ret = 0;
                    }
                } else if (action == 1) {
                    int licType = IDPRPCardInfo.CheckTypeEx(this.mOutBuffer, size[0]);
                    if (licType == 2) {
                        this.mPRPIDCardInfo = new IDPRPCardInfo();
                        this.mPRPIDCardInfo.unPacketExt(this.mOutBuffer, size[0]);
                        ret = licType;
                    } else if (licType == 1 || licType == 3) {
                        this.mIDCardInfo = null != idCardInfo ? idCardInfo : new IDCardInfo();
                        this.mIDCardInfo.setCardType(licType);
                        this.mIDCardInfo.unPacketExt(this.mOutBuffer, size[0]);
                        ret = licType;
                    } else {
                        ret = 0;
                    }
                }
            } else {
                this.freeIDCardData();
                this.idCardReaderSendData.setCmd((byte)48);
                if (action == 0) {
                    this.idCardReaderSendData.setPara((byte)1);
                } else if (action == 1) {
                    this.idCardReaderSendData.setPara((byte)16);
                } else {
                    throw IDCardReaderException.readCardIDCardDeviceFailed(-20011);
                }
                this.controlDevice(index, this.idCardReaderSendData, this.idCardReaderRetData, 2000);
                if (this.idCardReaderRetData.getSw3() != -112) {
                    throw IDCardReaderException.readCardIDCardDeviceFailed(-21000 - this.idCardReaderRetData.getSw3());
                }
                int length = this.idCardReaderRetData.getDataLen();
                byte[] cardInfo = new byte[length];
                this.idCardReaderRetData.getData(cardInfo);
                if (action == 0) {
                    int licType = IDPRPCardInfo.CheckType(cardInfo, length);
                    if (licType == 2) {
                        this.mPRPIDCardInfo = new IDPRPCardInfo();
                        this.mPRPIDCardInfo.unPacket(cardInfo, length);
                        ret = licType;
                    } else if (licType == 1 || licType == 3) {
                        this.mIDCardInfo = null != idCardInfo ? idCardInfo : new IDCardInfo();
                        this.mIDCardInfo.setCardType(licType);
                        this.mIDCardInfo.unPacket(cardInfo, length);
                        ret = licType;
                    } else {
                        ret = 0;
                    }
                } else if (action == 1) {
                    int licType = IDPRPCardInfo.CheckTypeEx(cardInfo, length);
                    if (licType == 2) {
                        this.mPRPIDCardInfo = new IDPRPCardInfo();
                        this.mPRPIDCardInfo.unPacketExt(cardInfo, length);
                        ret = licType;
                    } else if (licType == 1 || licType == 3) {
                        this.mIDCardInfo = null != idCardInfo ? idCardInfo : new IDCardInfo();
                        this.mIDCardInfo.setCardType(licType);
                        this.mIDCardInfo.unPacketExt(cardInfo, length);
                        ret = licType;
                    } else {
                        ret = 0;
                    }
                }
            }
        }
        catch (IDCardReaderException e) {
            LogHelper.e((String)("sdtapiSelect " + index + " failed!Reason: " + e.getMessage() + "Error code: " + e.getErrorCode() + "Internal error code: " + e.getInternalErrorCode()));
            ret = 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readCard(int index, int action, IDCardInfo idCardInfo) throws IDCardReaderException {
        Object object = this.deviceLock;
        synchronized (object) {
            long nTickSet = System.currentTimeMillis();
            int nRet = 0;
            while (System.currentTimeMillis() - nTickSet < 500L && (nRet = this.readCard_Imp(index, action, idCardInfo)) <= 0) {
            }
            if (1 == nRet) {
                idCardInfo = this.getLastIDCardInfo();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readCardEx(int index, int action) throws IDCardReaderException {
        Object object = this.deviceLock;
        synchronized (object) {
            int nRet = 0;
            long nTickSet = System.currentTimeMillis();
            while (System.currentTimeMillis() - nTickSet < 500L && (nRet = this.readCard_Imp(index, action, null)) <= 0) {
            }
            return nRet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.deviceLock;
        synchronized (object) {
            this.transportDevice.destroy();
            this.mOutBuffer = null;
            this.mInBuffer = null;
            this.mTempBuffer = null;
            this.idCardReaderSendData = null;
            this.idCardReaderRetData = null;
            this.icCardReaderSendData = null;
            this.icCardReaderRetData = null;
            this.mIDCardInfo = null;
            this.mPRPIDCardInfo = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean MF_Read(int index, byte mode, byte blockCount, byte startAddress, byte[] key, byte[] cardNum, byte[] dataCard) throws IDCardReaderException {
        Object object = this.deviceLock;
        synchronized (object) {
            boolean ret = false;
            try {
                if (this.transportDevice.getType() == TransportType.USB && -1 != this.BaudRate) {
                    LogHelper.e((String)("Check transportDevice type " + index + " failed!Reason: " + "not support!"));
                    throw IDCardReaderException.TransportDeviceNotSupport(-20011);
                }
                this.freeICCardData();
                this.icCardReaderSendData.setCmd((byte)32);
                byte[] data = new byte[9];
                data[0] = mode;
                data[1] = blockCount;
                data[2] = startAddress;
                if (key.length != 6) {
                    LogHelper.e((String)("MF_Read " + index + " failed!Reason: " + "ERROR KEY"));
                    throw IDCardReaderException.MFReadICCardDeviceFailed(-20018);
                }
                System.arraycopy(key, 0, data, 3, 6);
                this.icCardReaderSendData.setData(data);
                this.ic_controlDevice(index, this.icCardReaderSendData, this.icCardReaderRetData, 2000);
                if (this.icCardReaderRetData.getStatus() != 0) {
                    throw IDCardReaderException.selectCardIDCardDeviceFailed(-21000 - this.icCardReaderRetData.getStatus());
                }
                int Len = this.icCardReaderRetData.getDataLen();
                byte[] dataOut = new byte[Len - 1];
                System.arraycopy(this.icCardReaderRetData.getData(), 0, dataOut, 0, Len - 1);
                System.arraycopy(dataOut, 0, cardNum, 0, 4);
                if (dataCard.length < Len - 1 - 4) {
                    LogHelper.e((String)("MF_Read " + index + " failed!Reason: " + "dataCard space is empty or enough!"));
                    throw IDCardReaderException.MFReadICCardDeviceFailed(-20017);
                }
                System.arraycopy(dataOut, 4, dataCard, 0, Len - 1 - 4);
                ret = true;
            }
            catch (IDCardReaderException e) {
                LogHelper.e((String)("MF_Read " + index + " failed!Reason: " + e.getMessage() + "Error code: " + e.getErrorCode() + "Internal error code: " + e.getInternalErrorCode()));
                throw IDCardReaderException.MFReadICCardDeviceFailed(e.getErrorCode());
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean MF_Write(int index, byte mode, byte blockCount, byte startAddress, byte[] key, byte[] dataIn, byte[] cardNum) throws IDCardReaderException {
        Object object = this.deviceLock;
        synchronized (object) {
            boolean ret = false;
            if (this.transportDevice.getType() == TransportType.USB && -1 != this.BaudRate) {
                LogHelper.e((String)("Check transportDevice type " + index + " failed!Reason: " + "not support!"));
                throw IDCardReaderException.TransportDeviceNotSupport(-20011);
            }
            try {
                this.freeICCardData();
                this.icCardReaderSendData.setCmd((byte)33);
                byte[] data = new byte[9 + dataIn.length];
                data[0] = mode;
                data[1] = blockCount;
                data[2] = startAddress;
                if (key.length != 6) {
                    LogHelper.e((String)("MF_Read " + index + " failed!Reason: " + "ERROR KEY"));
                    throw IDCardReaderException.MFWriteICCardDeviceFailed(-20018);
                }
                System.arraycopy(key, 0, data, 3, 6);
                System.arraycopy(dataIn, 0, data, 9, dataIn.length);
                this.icCardReaderSendData.setData(data);
                this.ic_controlDevice(index, this.icCardReaderSendData, this.icCardReaderRetData, 2000);
                if (this.icCardReaderRetData.getStatus() != 0) {
                    throw IDCardReaderException.MFWriteICCardDeviceFailed(-21000 - this.icCardReaderRetData.getStatus());
                }
                int Len = this.icCardReaderRetData.getDataLen();
                System.arraycopy(this.icCardReaderRetData.getData(), 0, cardNum, 0, Len - 1);
                ret = true;
            }
            catch (IDCardReaderException e) {
                LogHelper.e((String)("MF_Write " + index + " failed!Reason: " + e.getMessage() + "Error code: " + e.getErrorCode() + "Internal error code: " + e.getInternalErrorCode()));
                throw IDCardReaderException.MFWriteICCardDeviceFailed(e.getErrorCode());
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean MF_GET_SNR(int index, byte mode, byte halt, byte[] cardNum) throws IDCardReaderException {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.transportDevice.getType() == TransportType.USB && -1 != this.BaudRate) {
                LogHelper.e((String)("Check transportDevice type " + index + " failed!Reason: " + "not support!"));
                throw IDCardReaderException.TransportDeviceNotSupport(-20011);
            }
            boolean ret = false;
            try {
                this.freeICCardData();
                this.icCardReaderSendData.setCmd((byte)37);
                byte[] data = new byte[]{mode, halt};
                this.icCardReaderSendData.setData(data);
                this.ic_controlDevice(index, this.icCardReaderSendData, this.icCardReaderRetData, 2000);
                if (this.icCardReaderRetData.getStatus() != 0) {
                    throw IDCardReaderException.MF_GET_SNRICCardDeviceFailed(-21000 - this.icCardReaderRetData.getStatus());
                }
                int Len = this.icCardReaderRetData.getDataLen();
                if (cardNum.length < Len - 1 - 1) {
                    LogHelper.e((String)("MF_GET_SNR " + index + " failed!Reason: " + "cardNum space is empty or not enough!"));
                    throw IDCardReaderException.MF_GET_SNRICCardDeviceFailed(-20017);
                }
                System.arraycopy(this.icCardReaderRetData.getData(), 1, cardNum, 0, Len - 1 - 1);
                ret = true;
            }
            catch (IDCardReaderException e) {
                LogHelper.e((String)("MF_GET_SNR " + index + " failed!Reason: " + e.getMessage() + "Error code: " + e.getErrorCode() + "Internal error code: " + e.getInternalErrorCode()));
                throw IDCardReaderException.MF_GET_SNRICCardDeviceFailed(e.getErrorCode());
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean MF_GET_NIDCardNum(int index, byte mode, byte halt, byte[] physicalCardNum) throws IDCardReaderException {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.transportDevice.getType() == TransportType.USB && -1 != this.BaudRate) {
                LogHelper.e((String)("Check transportDevice type " + index + " failed!Reason: " + "not support!"));
                throw IDCardReaderException.TransportDeviceNotSupport(-20011);
            }
            boolean ret = false;
            try {
                this.freeICCardData();
                this.icCardReaderSendData.setCmd((byte)38);
                byte[] data = new byte[]{mode, halt};
                this.icCardReaderSendData.setData(data);
                this.ic_controlDevice(index, this.icCardReaderSendData, this.icCardReaderRetData, 2000);
                if (this.icCardReaderRetData.getStatus() != 0) {
                    throw IDCardReaderException.MF_GET_PhysicalCardNumICCardDeviceFailed(-21000 - this.icCardReaderRetData.getStatus());
                }
                int Len = this.icCardReaderRetData.getDataLen();
                if (physicalCardNum.length < Len - 1) {
                    LogHelper.e((String)("MF_GET_PhysicalCardNum " + index + " failed!Reason: " + "physicalCardNum space is empty or not enough!"));
                    throw IDCardReaderException.MF_GET_PhysicalCardNumICCardDeviceFailed(-20017);
                }
                System.arraycopy(this.icCardReaderRetData.getData(), 0, physicalCardNum, 0, Len - 1);
                ret = true;
            }
            catch (IDCardReaderException e) {
                LogHelper.e((String)("MF_GET_PhysicalCardNum " + index + " failed!Reason: " + e.getMessage() + "Error code: " + e.getErrorCode() + "Internal error code: " + e.getInternalErrorCode()));
                throw IDCardReaderException.MF_GET_PhysicalCardNumICCardDeviceFailed(e.getErrorCode());
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean Get_VersionNum(int index, byte[] dataVersion) throws IDCardReaderException {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.transportDevice.getType() == TransportType.USB && -1 != this.BaudRate) {
                LogHelper.e((String)("Check transportDevice type " + index + " failed!Reason: " + "not support!"));
                throw IDCardReaderException.TransportDeviceNotSupport(-20011);
            }
            boolean ret = false;
            try {
                this.freeICCardData();
                this.icCardReaderSendData.setCmd((byte)-122);
                this.ic_controlDevice(index, this.icCardReaderSendData, this.icCardReaderRetData, 2000);
                if (this.icCardReaderRetData.getStatus() != 0) {
                    throw IDCardReaderException.Get_VersionNumICCardDeviceFailed(-21000 - this.icCardReaderRetData.getStatus());
                }
                int Len = this.icCardReaderRetData.getDataLen();
                if (dataVersion.length < Len - 1) {
                    LogHelper.e((String)("Get_VersionNum " + index + " failed!Reason: " + "dataVersion space is empty or not enough!"));
                    throw IDCardReaderException.Get_VersionNumICCardDeviceFailed(-20017);
                }
                System.arraycopy(this.icCardReaderRetData.getData(), 0, dataVersion, 0, Len - 1);
                ret = true;
            }
            catch (IDCardReaderException e) {
                LogHelper.e((String)("Get_VersionNum " + index + " failed!Reason: " + e.getMessage() + "Error code: " + e.getErrorCode() + "Internal error code: " + e.getInternalErrorCode()));
                throw IDCardReaderException.Get_VersionNumICCardDeviceFailed(e.getErrorCode());
            }
            return ret;
        }
    }

    public void SetBaudRate(int BaudRate) {
        if (BaudRate > 0) {
            this.BaudRate = BaudRate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ISO14443A_SetHalt(int index, byte dataType) throws IDCardReaderException {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.transportDevice.getType() == TransportType.USB && -1 != this.BaudRate) {
                LogHelper.e((String)("Check transportDevice type " + index + " failed!Reason: " + "not support!"));
                throw IDCardReaderException.TransportDeviceNotSupport(-20011);
            }
            boolean ret = false;
            try {
                this.freeICCardData();
                this.icCardReaderSendData.setCmd((byte)6);
                if (dataType != 78 || dataType != 65) {
                    LogHelper.e((String)"Error  dateType ! Only select N or A");
                    return ret;
                }
                byte[] data = new byte[]{dataType};
                this.icCardReaderSendData.setData(data);
                this.ic_controlDevice(index, this.icCardReaderSendData, this.icCardReaderRetData, 2000);
                if (this.icCardReaderRetData.getStatus() != 0) {
                    byte[] errorReason = new byte[1];
                    int Len = this.icCardReaderRetData.getDataLen();
                    System.arraycopy(this.icCardReaderRetData.getData(), 0, errorReason, 0, 1);
                    LogHelper.e((String)("SerHalt Erroor return code: " + errorReason[0]));
                    throw IDCardReaderException.MF_SET_HaltFailed(-21000 - this.icCardReaderRetData.getStatus());
                }
                ret = true;
            }
            catch (IDCardReaderException e) {
                LogHelper.e((String)("SetHalt failed " + index + " failed!Reason: " + e.getMessage() + "Error code: " + e.getErrorCode() + "Internal error code: " + e.getInternalErrorCode()));
                throw IDCardReaderException.MF_SET_HaltFailed(e.getErrorCode());
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ISO15693_Inventory(int index, byte flag, byte afi, byte maskLen, byte[] maskValue, byte[] cardNum) throws IDCardReaderException {
        boolean ret = false;
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.transportDevice.getType() == TransportType.USB && -1 != this.BaudRate) {
                LogHelper.e((String)("Check transportDevice type " + index + " failed!Reason: " + "not support!"));
                throw IDCardReaderException.TransportDeviceNotSupport(-20011);
            }
            if (null == cardNum || cardNum.length < 8 || maskLen > 0 && (maskValue == null || maskValue.length != maskLen)) {
                throw IDCardReaderException.ISO15693_INVENTORY_Failed(-9999);
            }
            this.freeICCardData();
            this.icCardReaderSendData.setCmd((byte)16);
            byte[] data = new byte[3 + maskLen];
            data[0] = flag;
            data[1] = afi;
            data[2] = maskLen;
            if (maskLen > 0) {
                System.arraycopy(maskValue, 0, data, 3, maskLen);
            }
            this.icCardReaderSendData.setData(data);
            this.ic_controlDevice(index, this.icCardReaderSendData, this.icCardReaderRetData, 2000);
            if (this.icCardReaderRetData.getStatus() != 0) {
                byte[] errorReason = new byte[1];
                int Len = this.icCardReaderRetData.getDataLen();
                System.arraycopy(this.icCardReaderRetData.getData(), 0, errorReason, 0, 1);
                LogHelper.e((String)("ISO15693_Inventory Erroor return code: " + errorReason[0]));
                throw IDCardReaderException.ISO15693_INVENTORY_Failed(-21000 - this.icCardReaderRetData.getStatus());
            }
            data = this.icCardReaderRetData.getData();
            if (data.length >= 8) {
                System.arraycopy(data, 0, cardNum, 0, 8);
                ret = true;
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean GetDNCode(int index, byte[] dnCode) throws IDCardReaderException {
        if (null == dnCode) {
            return false;
        }
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.transportDevice.getType() == TransportType.USB && -1 != this.BaudRate) {
                LogHelper.e((String)("Check transportDevice type " + index + " failed!Reason: " + "not support!"));
                throw IDCardReaderException.TransportDeviceNotSupport(-20011);
            }
            boolean ret = false;
            try {
                this.freeICCardData();
                this.icCardReaderSendData.setCmd((byte)41);
                byte[] data = new byte[]{38, 0};
                this.icCardReaderSendData.setData(data);
                this.ic_controlDevice(index, this.icCardReaderSendData, this.icCardReaderRetData, 2000);
                if (this.icCardReaderRetData.getStatus() != 0) {
                    throw IDCardReaderException.MF_GET_PhysicalCardNumICCardDeviceFailed(-21000 - this.icCardReaderRetData.getStatus());
                }
                int Len = this.icCardReaderRetData.getDataLen();
                if (dnCode.length < Len - 1) {
                    LogHelper.e((String)("GetDNCode " + index + " failed!Reason: " + "dncode space is empty or not enough!"));
                    throw IDCardReaderException.GetDNCodeFail(-20017);
                }
                System.arraycopy(this.icCardReaderRetData.getData(), 0, dnCode, 0, Len - 1);
                ret = true;
            }
            catch (IDCardReaderException e) {
                LogHelper.e((String)("GetDNCode " + index + " failed!Reason: " + e.getMessage() + "Error code: " + e.getErrorCode() + "Internal error code: " + e.getInternalErrorCode()));
                throw IDCardReaderException.GetDNCodeFail(e.getErrorCode());
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String GetBankCardNum(int index) throws IDCardReaderException {
        String strRet = "";
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.transportDevice.getType() == TransportType.USB && -1 != this.BaudRate) {
                LogHelper.e((String)("Check transportDevice type " + index + " failed!Reason: " + "not support!"));
                throw IDCardReaderException.TransportDeviceNotSupport(-20011);
            }
            this.freeICCardData();
            this.icCardReaderSendData.setCmd((byte)39);
            byte[] data = new byte[]{36, 0};
            this.icCardReaderSendData.setData(data);
            this.ic_controlDevice(index, this.icCardReaderSendData, this.icCardReaderRetData, 2000);
            if (this.icCardReaderRetData.getStatus() != 0) {
                byte[] errorReason = new byte[1];
                System.arraycopy(this.icCardReaderRetData.getData(), 0, errorReason, 0, 1);
                LogHelper.e((String)("GetBankCardNum Error return code: " + errorReason[0]));
                throw IDCardReaderException.GetBankCardNumFail(-21000 - this.icCardReaderRetData.getStatus());
            }
            data = this.icCardReaderRetData.getData();
            int dataLen = this.icCardReaderRetData.getDataLen();
            byte cardNumLen = data[0];
            if (cardNumLen <= 0 || cardNumLen > (data.length - 1) * 2) {
                LogHelper.e((String)("cardNumLen = " + cardNumLen + ",but dataLen = " + (data.length - 1)));
                strRet = "";
            } else {
                strRet = ToolUtils.bytesToHexString((byte[])data, (int)1, (int)(data.length - 1));
                LogHelper.i((String)("Org cardNum = " + strRet));
                strRet = strRet.substring(0, cardNumLen);
                LogHelper.i((String)("carLen = :" + cardNumLen + ",cardNum = " + strRet));
            }
            return strRet;
        }
    }
}

